/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.trading.rules;

import org.ta4j.core.Indicator;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.indicators.helpers.ConstantIndicator;
import org.ta4j.core.num.Num;
import org.ta4j.core.trading.rules.AbstractRule;

public class UnderIndicatorRule
extends AbstractRule {
    private final Indicator<Num> first;
    private final Indicator<Num> second;

    public UnderIndicatorRule(Indicator<Num> indicator, Number threshold) {
        this(indicator, new ConstantIndicator<Num>(indicator.getBarSeries(), indicator.numOf(threshold)));
    }

    public UnderIndicatorRule(Indicator<Num> indicator, Num threshold) {
        this(indicator, new ConstantIndicator<Num>(indicator.getBarSeries(), threshold));
    }

    public UnderIndicatorRule(Indicator<Num> first, Indicator<Num> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        boolean satisfied = this.first.getValue(index).isLessThan(this.second.getValue(index));
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }
}

