/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.trading.rules;

import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.indicators.helpers.HighestValueIndicator;
import org.ta4j.core.indicators.helpers.LowestValueIndicator;
import org.ta4j.core.indicators.helpers.PriceIndicator;
import org.ta4j.core.num.Num;
import org.ta4j.core.trading.rules.AbstractRule;

public class TrailingStopLossRule
extends AbstractRule {
    private final PriceIndicator priceIndicator;
    private Num currentExtremum = null;
    private Num currentStopLossLimitActivation = null;
    private int barCount;
    private final Num lossPercentage;

    public TrailingStopLossRule(PriceIndicator priceIndicator, Num lossPercentage, int barCount) {
        this.priceIndicator = priceIndicator;
        this.barCount = barCount;
        this.lossPercentage = lossPercentage;
    }

    public TrailingStopLossRule(PriceIndicator priceIndicator, Num lossPercentage) {
        this(priceIndicator, lossPercentage, Integer.MAX_VALUE);
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        Trade currentTrade;
        boolean satisfied = false;
        if (tradingRecord != null && (currentTrade = tradingRecord.getCurrentTrade()).isOpened()) {
            Num currentPrice = (Num)this.priceIndicator.getValue(index);
            int tradeIndex = currentTrade.getEntry().getIndex();
            satisfied = currentTrade.getEntry().isBuy() ? this.isBuySatisfied(currentPrice, index, tradeIndex) : this.isSellSatisfied(currentPrice, index, tradeIndex);
        }
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }

    private boolean isBuySatisfied(Num currentPrice, int index, int tradeIndex) {
        HighestValueIndicator highest = new HighestValueIndicator(this.priceIndicator, this.getValueIndicatorBarCount(index, tradeIndex));
        Num highestCloseNum = (Num)highest.getValue(index);
        Num lossRatioThreshold = highestCloseNum.numOf(100).minus(this.lossPercentage).dividedBy(highestCloseNum.numOf(100));
        this.currentStopLossLimitActivation = highestCloseNum.multipliedBy(lossRatioThreshold);
        return currentPrice.isLessThanOrEqual(this.currentStopLossLimitActivation);
    }

    public Num getCurrentStopLossLimitActivation() {
        return this.currentStopLossLimitActivation;
    }

    private boolean isSellSatisfied(Num currentPrice, int index, int tradeIndex) {
        LowestValueIndicator lowest = new LowestValueIndicator(this.priceIndicator, this.getValueIndicatorBarCount(index, tradeIndex));
        Num lowestCloseNum = (Num)lowest.getValue(index);
        Num lossRatioThreshold = lowestCloseNum.numOf(100).plus(this.lossPercentage).dividedBy(lowestCloseNum.numOf(100));
        this.currentStopLossLimitActivation = lowestCloseNum.multipliedBy(lossRatioThreshold);
        return currentPrice.isGreaterThanOrEqual(this.currentStopLossLimitActivation);
    }

    private int getValueIndicatorBarCount(int index, int tradeIndex) {
        return Math.min(index - tradeIndex + 1, this.barCount);
    }

    @Override
    protected void traceIsSatisfied(int index, boolean isSatisfied) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("{}#isSatisfied({}): {}. Current price: {}, Current stop loss activation: {}", new Object[]{this.getClass().getSimpleName(), index, isSatisfied, this.priceIndicator.getValue(index), this.currentStopLossLimitActivation});
        }
    }
}

