/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.trading.rules;

import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.indicators.helpers.ClosePriceIndicator;
import org.ta4j.core.num.Num;
import org.ta4j.core.trading.rules.AbstractRule;

public class StopLossRule
extends AbstractRule {
    private final Num HUNDRED;
    private final ClosePriceIndicator closePrice;
    private Num lossPercentage;

    public StopLossRule(ClosePriceIndicator closePrice, Number lossPercentage) {
        this(closePrice, closePrice.numOf(lossPercentage));
    }

    public StopLossRule(ClosePriceIndicator closePrice, Num lossPercentage) {
        this.closePrice = closePrice;
        this.lossPercentage = lossPercentage;
        this.HUNDRED = closePrice.numOf(100);
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        Trade currentTrade;
        boolean satisfied = false;
        if (tradingRecord != null && (currentTrade = tradingRecord.getCurrentTrade()).isOpened()) {
            Num entryPrice = currentTrade.getEntry().getNetPrice();
            Num currentPrice = (Num)this.closePrice.getValue(index);
            satisfied = currentTrade.getEntry().isBuy() ? this.isBuyStopSatisfied(entryPrice, currentPrice) : this.isSellStopSatisfied(entryPrice, currentPrice);
        }
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }

    private boolean isSellStopSatisfied(Num entryPrice, Num currentPrice) {
        Num lossRatioThreshold = this.HUNDRED.plus(this.lossPercentage).dividedBy(this.HUNDRED);
        Num threshold = entryPrice.multipliedBy(lossRatioThreshold);
        return currentPrice.isGreaterThanOrEqual(threshold);
    }

    private boolean isBuyStopSatisfied(Num entryPrice, Num currentPrice) {
        Num lossRatioThreshold = this.HUNDRED.minus(this.lossPercentage).dividedBy(this.HUNDRED);
        Num threshold = entryPrice.multipliedBy(lossRatioThreshold);
        return currentPrice.isLessThanOrEqual(threshold);
    }
}

