/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.trading.rules;

import org.ta4j.core.Trade;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.indicators.helpers.ClosePriceIndicator;
import org.ta4j.core.num.Num;
import org.ta4j.core.trading.rules.AbstractRule;

public class StopGainRule
extends AbstractRule {
    private final Num HUNDRED;
    private final ClosePriceIndicator closePrice;
    private final Num gainPercentage;

    public StopGainRule(ClosePriceIndicator closePrice, Number gainPercentage) {
        this(closePrice, closePrice.numOf(gainPercentage));
    }

    public StopGainRule(ClosePriceIndicator closePrice, Num gainPercentage) {
        this.closePrice = closePrice;
        this.gainPercentage = gainPercentage;
        this.HUNDRED = closePrice.numOf(100);
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        Trade currentTrade;
        boolean satisfied = false;
        if (tradingRecord != null && (currentTrade = tradingRecord.getCurrentTrade()).isOpened()) {
            Num entryPrice = currentTrade.getEntry().getNetPrice();
            Num currentPrice = (Num)this.closePrice.getValue(index);
            satisfied = currentTrade.getEntry().isBuy() ? this.isBuyGainSatisfied(entryPrice, currentPrice) : this.isSellGainSatisfied(entryPrice, currentPrice);
        }
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }

    private boolean isSellGainSatisfied(Num entryPrice, Num currentPrice) {
        Num lossRatioThreshold = this.HUNDRED.minus(this.gainPercentage).dividedBy(this.HUNDRED);
        Num threshold = entryPrice.multipliedBy(lossRatioThreshold);
        return currentPrice.isLessThanOrEqual(threshold);
    }

    private boolean isBuyGainSatisfied(Num entryPrice, Num currentPrice) {
        Num lossRatioThreshold = this.HUNDRED.plus(this.gainPercentage).dividedBy(this.HUNDRED);
        Num threshold = entryPrice.multipliedBy(lossRatioThreshold);
        return currentPrice.isGreaterThanOrEqual(threshold);
    }
}

