/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.trading.rules;

import org.ta4j.core.Indicator;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.indicators.helpers.HighestValueIndicator;
import org.ta4j.core.num.Num;
import org.ta4j.core.trading.rules.AbstractRule;

public class IsHighestRule
extends AbstractRule {
    private final Indicator<Num> ref;
    private final int barCount;

    public IsHighestRule(Indicator<Num> ref, int barCount) {
        this.ref = ref;
        this.barCount = barCount;
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        HighestValueIndicator highest = new HighestValueIndicator(this.ref, this.barCount);
        Num highestVal = (Num)highest.getValue(index);
        Num refVal = this.ref.getValue(index);
        boolean satisfied = !refVal.isNaN() && !highestVal.isNaN() && refVal.equals(highestVal);
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }
}

