/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.trading.rules;

import org.ta4j.core.Indicator;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.num.Num;
import org.ta4j.core.trading.rules.AbstractRule;

public class IsFallingRule
extends AbstractRule {
    private final Indicator<Num> ref;
    private final int barCount;
    private double minStrenght;

    public IsFallingRule(Indicator<Num> ref, int barCount) {
        this(ref, barCount, 1.0);
    }

    public IsFallingRule(Indicator<Num> ref, int barCount, double minStrenght) {
        this.ref = ref;
        this.barCount = barCount;
        this.minStrenght = minStrenght;
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        if (this.minStrenght >= 1.0) {
            this.minStrenght = 0.99;
        }
        int count = 0;
        for (int i = Math.max(0, index - this.barCount + 1); i <= index; ++i) {
            if (!this.ref.getValue(i).isLessThan(this.ref.getValue(Math.max(0, i - 1)))) continue;
            ++count;
        }
        double ratio = (double)count / (double)this.barCount;
        boolean satisfied = ratio >= this.minStrenght;
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }
}

