/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.trading.rules;

import org.ta4j.core.Indicator;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.indicators.helpers.DifferenceIndicator;
import org.ta4j.core.indicators.helpers.PreviousValueIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;
import org.ta4j.core.trading.rules.AbstractRule;

public class InSlopeRule
extends AbstractRule {
    private Indicator<Num> ref;
    private PreviousValueIndicator prev;
    private Num minSlope;
    private Num maxSlope;

    public InSlopeRule(Indicator<Num> ref, Num minSlope) {
        this(ref, 1, minSlope, NaN.NaN);
    }

    public InSlopeRule(Indicator<Num> ref, Num minSlope, Num maxSlope) {
        this(ref, 1, minSlope, maxSlope);
    }

    public InSlopeRule(Indicator<Num> ref, int nthPrevious, Num maxSlope) {
        this(ref, nthPrevious, NaN.NaN, maxSlope);
    }

    public InSlopeRule(Indicator<Num> ref, int nthPrevious, Num minSlope, Num maxSlope) {
        this.ref = ref;
        this.prev = new PreviousValueIndicator(ref, nthPrevious);
        this.minSlope = minSlope;
        this.maxSlope = maxSlope;
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        DifferenceIndicator diff = new DifferenceIndicator(this.ref, this.prev);
        Num val = (Num)diff.getValue(index);
        boolean minSlopeSatisfied = this.minSlope.isNaN() || val.isGreaterThanOrEqual(this.minSlope);
        boolean maxSlopeSatisfied = this.maxSlope.isNaN() || val.isLessThanOrEqual(this.maxSlope);
        boolean isNaN = this.minSlope.isNaN() && this.maxSlope.isNaN();
        boolean satisfied = minSlopeSatisfied && maxSlopeSatisfied && !isNaN;
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }
}

