/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.trading.rules;

import org.ta4j.core.Indicator;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.indicators.helpers.ConstantIndicator;
import org.ta4j.core.num.Num;
import org.ta4j.core.trading.rules.AbstractRule;

public class InPipeRule
extends AbstractRule {
    private Indicator<Num> upper;
    private Indicator<Num> lower;
    private Indicator<Num> ref;

    public InPipeRule(Indicator<Num> ref, Number upper, Number lower) {
        this(ref, ref.numOf(upper), ref.numOf(lower));
    }

    public InPipeRule(Indicator<Num> ref, Num upper, Num lower) {
        this(ref, new ConstantIndicator<Num>(ref.getBarSeries(), upper), new ConstantIndicator<Num>(ref.getBarSeries(), lower));
    }

    public InPipeRule(Indicator<Num> ref, Indicator<Num> upper, Indicator<Num> lower) {
        this.upper = upper;
        this.lower = lower;
        this.ref = ref;
    }

    @Override
    public boolean isSatisfied(int index, TradingRecord tradingRecord) {
        boolean satisfied = this.ref.getValue(index).isLessThanOrEqual(this.upper.getValue(index)) && this.ref.getValue(index).isGreaterThanOrEqual(this.lower.getValue(index));
        this.traceIsSatisfied(index, satisfied);
        return satisfied;
    }
}

