/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.tradereport;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Strategy;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.tradereport.PerformanceReport;
import org.ta4j.core.tradereport.PerformanceReportGenerator;
import org.ta4j.core.tradereport.ReportGenerator;
import org.ta4j.core.tradereport.TradeStatsReport;
import org.ta4j.core.tradereport.TradeStatsReportGenerator;
import org.ta4j.core.tradereport.TradingStatement;

public class TradingStatementGenerator
implements ReportGenerator<TradingStatement> {
    private final PerformanceReportGenerator performanceReportGenerator;
    private final TradeStatsReportGenerator tradeStatsReportGenerator;

    public TradingStatementGenerator() {
        this(new PerformanceReportGenerator(), new TradeStatsReportGenerator());
    }

    public TradingStatementGenerator(PerformanceReportGenerator performanceReportGenerator, TradeStatsReportGenerator tradeStatsReportGenerator) {
        this.performanceReportGenerator = performanceReportGenerator;
        this.tradeStatsReportGenerator = tradeStatsReportGenerator;
    }

    @Override
    public TradingStatement generate(Strategy strategy, TradingRecord tradingRecord, BarSeries series) {
        PerformanceReport performanceReport = this.performanceReportGenerator.generate(strategy, tradingRecord, series);
        TradeStatsReport tradeStatsReport = this.tradeStatsReportGenerator.generate(strategy, tradingRecord, series);
        return new TradingStatement(strategy, tradeStatsReport, performanceReport);
    }
}

