/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.tradereport;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Strategy;
import org.ta4j.core.TradingRecord;
import org.ta4j.core.analysis.criteria.ProfitLossCriterion;
import org.ta4j.core.analysis.criteria.ProfitLossPercentageCriterion;
import org.ta4j.core.analysis.criteria.TotalLossCriterion;
import org.ta4j.core.analysis.criteria.TotalProfit2Criterion;
import org.ta4j.core.num.Num;
import org.ta4j.core.tradereport.PerformanceReport;
import org.ta4j.core.tradereport.ReportGenerator;

public class PerformanceReportGenerator
implements ReportGenerator<PerformanceReport> {
    @Override
    public PerformanceReport generate(Strategy strategy, TradingRecord tradingRecord, BarSeries series) {
        Num totalProfitLoss = new ProfitLossCriterion().calculate(series, tradingRecord);
        Num totalProfitLossPercentage = new ProfitLossPercentageCriterion().calculate(series, tradingRecord);
        Num totalProfit = new TotalProfit2Criterion().calculate(series, tradingRecord);
        Num totalLoss = new TotalLossCriterion().calculate(series, tradingRecord);
        return new PerformanceReport(totalProfitLoss, totalProfitLossPercentage, totalProfit, totalLoss);
    }
}

