/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.num;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public final class PrecisionNum
implements Num {
    private static final long serialVersionUID = 785564782721079992L;
    private static final int DEFAULT_PRECISION = 32;
    private static final Logger log = LoggerFactory.getLogger(PrecisionNum.class);
    private final MathContext mathContext;
    private final BigDecimal delegate;

    private PrecisionNum(String val) {
        this.delegate = new BigDecimal(val);
        int precision = Math.max(this.delegate.precision(), 32);
        this.mathContext = new MathContext(precision, RoundingMode.HALF_UP);
    }

    private PrecisionNum(String val, int precision) {
        this.mathContext = new MathContext(precision, RoundingMode.HALF_UP);
        this.delegate = new BigDecimal(val, new MathContext(precision, RoundingMode.HALF_UP));
    }

    private PrecisionNum(short val) {
        this.mathContext = new MathContext(32, RoundingMode.HALF_UP);
        this.delegate = new BigDecimal(val, this.mathContext);
    }

    private PrecisionNum(int val) {
        this.mathContext = new MathContext(32, RoundingMode.HALF_UP);
        this.delegate = BigDecimal.valueOf(val);
    }

    private PrecisionNum(long val) {
        this.mathContext = new MathContext(32, RoundingMode.HALF_UP);
        this.delegate = BigDecimal.valueOf(val);
    }

    private PrecisionNum(float val) {
        this.mathContext = new MathContext(32, RoundingMode.HALF_UP);
        this.delegate = new BigDecimal(val, this.mathContext);
    }

    private PrecisionNum(double val) {
        this.mathContext = new MathContext(32, RoundingMode.HALF_UP);
        this.delegate = BigDecimal.valueOf(val);
    }

    private PrecisionNum(BigDecimal val, int precision) {
        this.mathContext = new MathContext(precision, RoundingMode.HALF_UP);
        this.delegate = Objects.requireNonNull(val);
    }

    public static PrecisionNum valueOf(String val) {
        if (val.equalsIgnoreCase("NAN")) {
            throw new NumberFormatException();
        }
        return new PrecisionNum(val);
    }

    public static PrecisionNum valueOf(String val, int precision) {
        if (val.equalsIgnoreCase("NAN")) {
            throw new NumberFormatException();
        }
        return new PrecisionNum(val, precision);
    }

    public static PrecisionNum valueOf(short val) {
        return new PrecisionNum(val);
    }

    public static PrecisionNum valueOf(int val) {
        return new PrecisionNum(val);
    }

    public static PrecisionNum valueOf(long val) {
        return new PrecisionNum(val);
    }

    public static PrecisionNum valueOf(float val) {
        if (Float.isNaN(val)) {
            throw new NumberFormatException();
        }
        return new PrecisionNum(val);
    }

    public static PrecisionNum valueOf(BigDecimal val) {
        return new PrecisionNum(val, val.precision());
    }

    public static PrecisionNum valueOf(BigDecimal val, int precision) {
        return new PrecisionNum(val, precision);
    }

    public static PrecisionNum valueOf(double val) {
        if (Double.isNaN(val)) {
            throw new NumberFormatException();
        }
        return new PrecisionNum(val);
    }

    public static PrecisionNum valueOf(PrecisionNum val) {
        return val;
    }

    public static PrecisionNum valueOf(Number val) {
        return new PrecisionNum(val.toString());
    }

    @Override
    public Function<Number, Num> function() {
        return number -> PrecisionNum.valueOf(number.toString(), this.mathContext.getPrecision());
    }

    @Override
    public BigDecimal getDelegate() {
        return this.delegate;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Num plus(Num augend) {
        if (augend.isNaN()) {
            return NaN.NaN;
        }
        BigDecimal bigDecimal = ((PrecisionNum)augend).delegate;
        int precision = this.mathContext.getPrecision();
        BigDecimal result = this.delegate.add(bigDecimal, this.mathContext);
        return new PrecisionNum(result, precision);
    }

    @Override
    public Num minus(Num subtrahend) {
        if (subtrahend.isNaN()) {
            return NaN.NaN;
        }
        BigDecimal bigDecimal = ((PrecisionNum)subtrahend).delegate;
        int precision = this.mathContext.getPrecision();
        BigDecimal result = this.delegate.subtract(bigDecimal, this.mathContext);
        return new PrecisionNum(result, precision);
    }

    @Override
    public Num multipliedBy(Num multiplicand) {
        if (multiplicand.isNaN()) {
            return NaN.NaN;
        }
        BigDecimal bigDecimal = ((PrecisionNum)multiplicand).delegate;
        int precision = this.mathContext.getPrecision();
        BigDecimal result = this.delegate.multiply(bigDecimal, new MathContext(precision, RoundingMode.HALF_UP));
        return new PrecisionNum(result, precision);
    }

    @Override
    public Num dividedBy(Num divisor) {
        if (divisor.isNaN() || divisor.isZero()) {
            return NaN.NaN;
        }
        BigDecimal bigDecimal = ((PrecisionNum)divisor).delegate;
        int precision = this.mathContext.getPrecision();
        BigDecimal result = this.delegate.divide(bigDecimal, new MathContext(precision, RoundingMode.HALF_UP));
        return new PrecisionNum(result, precision);
    }

    @Override
    public Num remainder(Num divisor) {
        BigDecimal bigDecimal = ((PrecisionNum)divisor).delegate;
        int precision = this.mathContext.getPrecision();
        BigDecimal result = this.delegate.remainder(bigDecimal, new MathContext(precision, RoundingMode.HALF_UP));
        return new PrecisionNum(result, precision);
    }

    public Num floor() {
        int precision = Math.max(this.mathContext.getPrecision(), 32);
        return new PrecisionNum(this.delegate.setScale(0, RoundingMode.FLOOR), precision);
    }

    public Num ceil() {
        int precision = Math.max(this.mathContext.getPrecision(), 32);
        return new PrecisionNum(this.delegate.setScale(0, RoundingMode.CEILING), precision);
    }

    @Override
    public Num pow(int n) {
        int precision = this.mathContext.getPrecision();
        BigDecimal result = this.delegate.pow(n, new MathContext(precision, RoundingMode.HALF_UP));
        return new PrecisionNum(result, precision);
    }

    @Override
    public Num sqrt() {
        return this.sqrt(32);
    }

    @Override
    public Num sqrt(int precision) {
        BigDecimal delta;
        String estimateString;
        log.trace("delegate {}", (Object)this.delegate);
        int comparedToZero = this.delegate.compareTo(BigDecimal.ZERO);
        switch (comparedToZero) {
            case -1: {
                return NaN.NaN;
            }
            case 0: {
                return PrecisionNum.valueOf(0);
            }
        }
        MathContext precisionContext = new MathContext(precision, RoundingMode.HALF_UP);
        BigDecimal estimate = new BigDecimal(this.delegate.toString(), precisionContext);
        String string = String.format(Locale.ROOT, "%1.1e", estimate);
        log.trace("scientific notation {}", (Object)string);
        if (string.contains("e")) {
            String[] parts = string.split("e");
            BigDecimal mantissa = new BigDecimal(parts[0]);
            BigDecimal exponent = new BigDecimal(parts[1]);
            if (exponent.remainder(new BigDecimal(2)).compareTo(BigDecimal.ZERO) > 0) {
                exponent = exponent.subtract(BigDecimal.ONE);
                mantissa = mantissa.multiply(BigDecimal.TEN);
                log.trace("modified notatation {}e{}", (Object)mantissa, (Object)exponent);
            }
            BigDecimal estimatedMantissa = mantissa.compareTo(BigDecimal.TEN) < 0 ? new BigDecimal(2) : new BigDecimal(6);
            BigDecimal estimatedExponent = exponent.divide(new BigDecimal(2));
            estimateString = String.format("%sE%s", estimatedMantissa, estimatedExponent);
            log.trace("x[0] =~ sqrt({}...*10^{}) =~ {}", new Object[]{mantissa, exponent, estimateString});
            DecimalFormat format = new DecimalFormat();
            format.setParseBigDecimal(true);
            try {
                estimate = (BigDecimal)format.parse(estimateString);
            }
            catch (ParseException e) {
                log.error("PrecicionNum ParseException:", (Throwable)e);
            }
        }
        BigDecimal two = new BigDecimal(2);
        int i = 1;
        do {
            BigDecimal test = this.delegate.divide(estimate, precisionContext);
            BigDecimal sum = estimate.add(test);
            BigDecimal newEstimate = sum.divide(two, precisionContext);
            delta = newEstimate.subtract(estimate).abs();
            estimate = newEstimate;
            if (!log.isTraceEnabled()) continue;
            estimateString = String.format("%1." + precision + "e", estimate);
            int endIndex = estimateString.length();
            int frontEndIndex = 20 > endIndex ? endIndex : 20;
            int backStartIndex = 20 > endIndex ? 0 : endIndex - 20;
            log.trace("x[{}] = {}..{}, delta = {}", new Object[]{i, estimateString.substring(0, frontEndIndex), estimateString.substring(backStartIndex, endIndex), String.format("%1.1e", delta)});
            ++i;
        } while (delta.compareTo(BigDecimal.ZERO) > 0);
        return PrecisionNum.valueOf(estimate, precision);
    }

    @Override
    public Num log() {
        PrecisionNum logx;
        if (this.isNegativeOrZero()) {
            return NaN.NaN;
        }
        if (this.delegate.equals(BigDecimal.ONE)) {
            logx = PrecisionNum.valueOf(BigDecimal.ZERO, this.mathContext.getPrecision());
        } else {
            long ITER = 1000L;
            BigDecimal x = this.delegate.subtract(BigDecimal.ONE);
            BigDecimal ret = new BigDecimal(ITER + 1L);
            for (long i = ITER; i >= 0L; --i) {
                BigDecimal N = new BigDecimal(i / 2L + 1L).pow(2);
                N = N.multiply(x, this.mathContext);
                ret = N.divide(ret, this.mathContext);
                N = new BigDecimal(i + 1L);
                ret = ret.add(N, this.mathContext);
            }
            ret = x.divide(ret, this.mathContext);
            logx = PrecisionNum.valueOf(ret, this.mathContext.getPrecision());
        }
        return logx;
    }

    @Override
    public Num abs() {
        return new PrecisionNum(this.delegate.abs(), this.mathContext.getPrecision());
    }

    @Override
    public boolean isZero() {
        return this.delegate.signum() == 0;
    }

    @Override
    public boolean isPositive() {
        return this.delegate.signum() > 0;
    }

    @Override
    public boolean isPositiveOrZero() {
        return this.delegate.signum() >= 0;
    }

    @Override
    public boolean isNegative() {
        return this.delegate.signum() < 0;
    }

    @Override
    public boolean isNegativeOrZero() {
        return this.delegate.signum() <= 0;
    }

    @Override
    public boolean isEqual(Num other) {
        return !other.isNaN() && this.compareTo(other) == 0;
    }

    public boolean matches(Num other, int precision) {
        PrecisionNum otherNum = PrecisionNum.valueOf(other.toString(), precision);
        PrecisionNum thisNum = PrecisionNum.valueOf(this.toString(), precision);
        if (thisNum.toString().equals(otherNum.toString())) {
            return true;
        }
        log.debug("{} from {} does not match", (Object)thisNum, (Object)this);
        log.debug("{} from {} to precision {}", new Object[]{otherNum, other, precision});
        return false;
    }

    public boolean matches(Num other, Num delta) {
        Num result = this.minus(other);
        if (!result.isGreaterThan(delta)) {
            return true;
        }
        log.debug("{} does not match", (Object)this);
        log.debug("{} within offset {}", (Object)other, (Object)delta);
        return false;
    }

    @Override
    public boolean isGreaterThan(Num other) {
        return !other.isNaN() && this.compareTo(other) > 0;
    }

    @Override
    public boolean isGreaterThanOrEqual(Num other) {
        return !other.isNaN() && this.compareTo(other) > -1;
    }

    @Override
    public boolean isLessThan(Num other) {
        return !other.isNaN() && this.compareTo(other) < 0;
    }

    @Override
    public boolean isLessThanOrEqual(Num other) {
        return !other.isNaN() && this.delegate.compareTo(((PrecisionNum)other).delegate) < 1;
    }

    @Override
    public int compareTo(Num other) {
        return other.isNaN() ? 0 : this.delegate.compareTo(((PrecisionNum)other).delegate);
    }

    @Override
    public Num min(Num other) {
        return other.isNaN() ? NaN.NaN : (this.compareTo(other) <= 0 ? this : other);
    }

    @Override
    public Num max(Num other) {
        return other.isNaN() ? NaN.NaN : (this.compareTo(other) >= 0 ? this : other);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PrecisionNum)) {
            return false;
        }
        return this.delegate.compareTo(((PrecisionNum)obj).delegate) == 0;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Num pow(Num n) {
        BigDecimal aplusb = ((PrecisionNum)n).delegate;
        BigDecimal b = aplusb.remainder(BigDecimal.ONE);
        double bDouble = b.doubleValue();
        BigDecimal a = aplusb.subtract(b);
        int aInt = a.intValueExact();
        BigDecimal xpowa = this.delegate.pow(aInt);
        double xpowb = Math.pow(this.delegate.doubleValue(), bDouble);
        BigDecimal result = xpowa.multiply(new BigDecimal(xpowb));
        return new PrecisionNum(result.toString());
    }
}

