/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.num;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.function.Function;

public interface Num
extends Comparable<Num>,
Serializable {
    public Number getDelegate();

    public String getName();

    public Num plus(Num var1);

    public Num minus(Num var1);

    public Num multipliedBy(Num var1);

    public Num dividedBy(Num var1);

    public Num remainder(Num var1);

    public Num pow(int var1);

    public Num pow(Num var1);

    public Num log();

    public Num sqrt();

    public Num sqrt(int var1);

    public Num abs();

    public boolean isZero();

    public boolean isPositive();

    public boolean isPositiveOrZero();

    public boolean isNegative();

    public boolean isNegativeOrZero();

    public boolean isEqual(Num var1);

    public boolean isGreaterThan(Num var1);

    public boolean isGreaterThanOrEqual(Num var1);

    public boolean isLessThan(Num var1);

    public boolean isLessThanOrEqual(Num var1);

    public Num min(Num var1);

    public Num max(Num var1);

    public Function<Number, Num> function();

    default public Num numOf(Number value) {
        return this.function().apply(value);
    }

    default public Num numOf(String value, int precision) {
        MathContext mathContext = new MathContext(precision, RoundingMode.HALF_UP);
        return this.numOf(new BigDecimal(value, mathContext));
    }

    default public boolean isNaN() {
        return false;
    }

    default public double doubleValue() {
        return this.getDelegate().doubleValue();
    }

    default public int intValue() {
        return this.getDelegate().intValue();
    }

    default public long longValue() {
        return this.getDelegate().longValue();
    }

    default public float floatValue() {
        return this.getDelegate().floatValue();
    }

    public int hashCode();

    public String toString();

    public boolean equals(Object var1);
}

