/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.num;

import java.util.function.Function;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class DoubleNum
implements Num {
    private static final long serialVersionUID = -2611177221813615070L;
    private static final double EPS = 1.0E-5;
    private final double delegate;

    private DoubleNum(double val) {
        this.delegate = val;
    }

    public static DoubleNum valueOf(int i) {
        return new DoubleNum(i);
    }

    public static DoubleNum valueOf(long i) {
        return new DoubleNum(i);
    }

    public static DoubleNum valueOf(short i) {
        return new DoubleNum(i);
    }

    public static DoubleNum valueOf(float i) {
        return new DoubleNum(i);
    }

    public static DoubleNum valueOf(String i) {
        return new DoubleNum(Double.parseDouble(i));
    }

    public static DoubleNum valueOf(Number i) {
        return new DoubleNum(Double.parseDouble(i.toString()));
    }

    @Override
    public Function<Number, Num> function() {
        return DoubleNum::valueOf;
    }

    @Override
    public Double getDelegate() {
        return this.delegate;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Num plus(Num augend) {
        return augend.isNaN() ? NaN.NaN : new DoubleNum(this.delegate + ((DoubleNum)augend).delegate);
    }

    @Override
    public Num minus(Num subtrahend) {
        return subtrahend.isNaN() ? NaN.NaN : new DoubleNum(this.delegate - ((DoubleNum)subtrahend).delegate);
    }

    @Override
    public Num multipliedBy(Num multiplicand) {
        return multiplicand.isNaN() ? NaN.NaN : new DoubleNum(this.delegate * ((DoubleNum)multiplicand).delegate);
    }

    @Override
    public Num dividedBy(Num divisor) {
        if (divisor.isNaN() || divisor.isZero()) {
            return NaN.NaN;
        }
        DoubleNum divisorD = (DoubleNum)divisor;
        return new DoubleNum(this.delegate / divisorD.delegate);
    }

    @Override
    public Num remainder(Num divisor) {
        return divisor.isNaN() ? NaN.NaN : new DoubleNum(this.delegate % ((DoubleNum)divisor).delegate);
    }

    @Override
    public Num pow(int n) {
        return new DoubleNum(Math.pow(this.delegate, n));
    }

    @Override
    public Num pow(Num n) {
        return new DoubleNum(Math.pow(this.delegate, n.doubleValue()));
    }

    @Override
    public Num sqrt() {
        if (this.delegate < 0.0) {
            return NaN.NaN;
        }
        return new DoubleNum(Math.sqrt(this.delegate));
    }

    @Override
    public Num sqrt(int precision) {
        return this.sqrt();
    }

    @Override
    public Num abs() {
        return new DoubleNum(Math.abs(this.delegate));
    }

    @Override
    public boolean isZero() {
        return this.delegate == 0.0;
    }

    @Override
    public boolean isPositive() {
        return this.delegate > 0.0;
    }

    @Override
    public boolean isPositiveOrZero() {
        return this.delegate >= 0.0;
    }

    @Override
    public boolean isNegative() {
        return this.delegate < 0.0;
    }

    @Override
    public boolean isNegativeOrZero() {
        return this.delegate <= 0.0;
    }

    @Override
    public boolean isEqual(Num other) {
        return !other.isNaN() && this.delegate == ((DoubleNum)other).delegate;
    }

    @Override
    public Num log() {
        if (this.delegate <= 0.0) {
            return NaN.NaN;
        }
        return new DoubleNum(Math.log(this.delegate));
    }

    @Override
    public boolean isGreaterThan(Num other) {
        return !other.isNaN() && this.compareTo(other) > 0;
    }

    @Override
    public boolean isGreaterThanOrEqual(Num other) {
        return !other.isNaN() && this.compareTo(other) > -1;
    }

    @Override
    public boolean isLessThan(Num other) {
        return !other.isNaN() && this.compareTo(other) < 0;
    }

    @Override
    public boolean isLessThanOrEqual(Num other) {
        return !other.isNaN() && this.compareTo(other) < 1;
    }

    @Override
    public Num min(Num other) {
        return other.isNaN() ? NaN.NaN : new DoubleNum(Math.min(this.delegate, ((DoubleNum)other).delegate));
    }

    @Override
    public Num max(Num other) {
        return other.isNaN() ? NaN.NaN : new DoubleNum(Math.max(this.delegate, ((DoubleNum)other).delegate));
    }

    @Override
    public int hashCode() {
        return Double.valueOf(this.delegate).hashCode();
    }

    @Override
    public String toString() {
        return Double.toString(this.delegate);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleNum)) {
            return false;
        }
        DoubleNum doubleNumObj = (DoubleNum)obj;
        return Math.abs(this.delegate - doubleNumObj.delegate) < 1.0E-5;
    }

    @Override
    public int compareTo(Num o) {
        if (this == NaN.NaN || o == NaN.NaN) {
            return 0;
        }
        DoubleNum doubleNumO = (DoubleNum)o;
        return Double.compare(this.delegate, doubleNumO.delegate);
    }
}

