/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.volume;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.TypicalPriceIndicator;
import org.ta4j.core.indicators.helpers.VolumeIndicator;
import org.ta4j.core.num.Num;

public class VWAPIndicator
extends CachedIndicator<Num> {
    private final int barCount;
    private final Indicator<Num> typicalPrice;
    private final Indicator<Num> volume;
    private final Num zero;

    public VWAPIndicator(BarSeries series, int barCount) {
        super(series);
        this.barCount = barCount;
        this.typicalPrice = new TypicalPriceIndicator(series);
        this.volume = new VolumeIndicator(series);
        this.zero = this.numOf(0);
    }

    @Override
    protected Num calculate(int index) {
        if (index <= 0) {
            return this.typicalPrice.getValue(index);
        }
        int startIndex = Math.max(0, index - this.barCount + 1);
        Num cumulativeTPV = this.zero;
        Num cumulativeVolume = this.zero;
        for (int i = startIndex; i <= index; ++i) {
            Num currentVolume = this.volume.getValue(i);
            cumulativeTPV = cumulativeTPV.plus(this.typicalPrice.getValue(i).multipliedBy(currentVolume));
            cumulativeVolume = cumulativeVolume.plus(currentVolume);
        }
        return cumulativeTPV.dividedBy(cumulativeVolume);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

