/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.volume;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.Num;

public class ROCVIndicator
extends CachedIndicator<Num> {
    private static final long serialVersionUID = 6366365574748347534L;
    private final int barCount;
    private final Num hundred;

    public ROCVIndicator(BarSeries series, int barCount) {
        super(series);
        this.barCount = barCount;
        this.hundred = this.numOf(100);
    }

    @Override
    protected Num calculate(int index) {
        int nIndex = Math.max(index - this.barCount, 0);
        Num nPeriodsAgoValue = this.getBarSeries().getBar(nIndex).getVolume();
        Num currentValue = this.getBarSeries().getBar(index).getVolume();
        return currentValue.minus(nPeriodsAgoValue).dividedBy(nPeriodsAgoValue).multipliedBy(this.hundred);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

