/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.volume;

import org.ta4j.core.Bar;
import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.RecursiveCachedIndicator;
import org.ta4j.core.num.Num;

public class PVIIndicator
extends RecursiveCachedIndicator<Num> {
    public PVIIndicator(BarSeries series) {
        super(series);
    }

    @Override
    protected Num calculate(int index) {
        if (index == 0) {
            return this.numOf(1000);
        }
        Bar currentBar = this.getBarSeries().getBar(index);
        Bar previousBar = this.getBarSeries().getBar(index - 1);
        Num previousValue = (Num)this.getValue(index - 1);
        if (currentBar.getVolume().isGreaterThan(previousBar.getVolume())) {
            Num currentPrice = currentBar.getClosePrice();
            Num previousPrice = previousBar.getClosePrice();
            Num priceChangeRatio = currentPrice.minus(previousPrice).dividedBy(previousPrice);
            return previousValue.plus(priceChangeRatio.multipliedBy(previousValue));
        }
        return previousValue;
    }
}

