/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.volume;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.RecursiveCachedIndicator;
import org.ta4j.core.num.Num;

public class OnBalanceVolumeIndicator
extends RecursiveCachedIndicator<Num> {
    private static final long serialVersionUID = -5870953997596403170L;

    public OnBalanceVolumeIndicator(BarSeries series) {
        super(series);
    }

    @Override
    protected Num calculate(int index) {
        if (index == 0) {
            return this.numOf(0);
        }
        Num prevClose = this.getBarSeries().getBar(index - 1).getClosePrice();
        Num currentClose = this.getBarSeries().getBar(index).getClosePrice();
        Num obvPrev = (Num)this.getValue(index - 1);
        if (prevClose.isGreaterThan(currentClose)) {
            return obvPrev.minus(this.getBarSeries().getBar(index).getVolume());
        }
        if (prevClose.isLessThan(currentClose)) {
            return obvPrev.plus(this.getBarSeries().getBar(index).getVolume());
        }
        return obvPrev;
    }
}

