/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.volume;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.ClosePriceIndicator;
import org.ta4j.core.indicators.helpers.HighPriceIndicator;
import org.ta4j.core.indicators.helpers.LowPriceIndicator;
import org.ta4j.core.indicators.helpers.VolumeIndicator;
import org.ta4j.core.num.Num;

public class IIIIndicator
extends CachedIndicator<Num> {
    private final ClosePriceIndicator closePriceIndicator;
    private final HighPriceIndicator highPriceIndicator;
    private final LowPriceIndicator lowPriceIndicator;
    private final VolumeIndicator volumeIndicator;
    private final Num two;

    public IIIIndicator(BarSeries series) {
        super(series);
        this.closePriceIndicator = new ClosePriceIndicator(series);
        this.highPriceIndicator = new HighPriceIndicator(series);
        this.lowPriceIndicator = new LowPriceIndicator(series);
        this.volumeIndicator = new VolumeIndicator(series);
        this.two = this.numOf(2);
    }

    @Override
    protected Num calculate(int index) {
        if (index == this.getBarSeries().getBeginIndex()) {
            return this.numOf(0);
        }
        Num doubledClosePrice = this.two.multipliedBy((Num)this.closePriceIndicator.getValue(index));
        Num high = (Num)this.highPriceIndicator.getValue(index);
        Num low = (Num)this.lowPriceIndicator.getValue(index);
        Num highMinusLow = high.minus(low);
        Num highPlusLow = high.plus(low);
        return doubledClosePrice.minus(highPlusLow).dividedBy(highMinusLow.multipliedBy((Num)this.volumeIndicator.getValue(index)));
    }
}

