/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.volume;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.EMAIndicator;
import org.ta4j.core.indicators.volume.AccumulationDistributionIndicator;
import org.ta4j.core.num.Num;

public class ChaikinOscillatorIndicator
extends CachedIndicator<Num> {
    private static final long serialVersionUID = 2235402541638515096L;
    private final EMAIndicator emaShort;
    private final EMAIndicator emaLong;

    public ChaikinOscillatorIndicator(BarSeries series, int shortBarCount, int longBarCount) {
        super(series);
        this.emaShort = new EMAIndicator(new AccumulationDistributionIndicator(series), shortBarCount);
        this.emaLong = new EMAIndicator(new AccumulationDistributionIndicator(series), longBarCount);
    }

    public ChaikinOscillatorIndicator(BarSeries series) {
        this(series, 3, 10);
    }

    @Override
    protected Num calculate(int index) {
        return ((Num)this.emaShort.getValue(index)).minus((Num)this.emaLong.getValue(index));
    }
}

