/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.volume;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.CloseLocationValueIndicator;
import org.ta4j.core.indicators.helpers.VolumeIndicator;
import org.ta4j.core.num.Num;

public class ChaikinMoneyFlowIndicator
extends CachedIndicator<Num> {
    private final CloseLocationValueIndicator clvIndicator;
    private final VolumeIndicator volumeIndicator;
    private final int barCount;

    public ChaikinMoneyFlowIndicator(BarSeries series, int barCount) {
        super(series);
        this.barCount = barCount;
        this.clvIndicator = new CloseLocationValueIndicator(series);
        this.volumeIndicator = new VolumeIndicator(series, barCount);
    }

    @Override
    protected Num calculate(int index) {
        int startIndex = Math.max(0, index - this.barCount + 1);
        Num sumOfMoneyFlowVolume = this.numOf(0);
        for (int i = startIndex; i <= index; ++i) {
            sumOfMoneyFlowVolume = sumOfMoneyFlowVolume.plus(this.getMoneyFlowVolume(i));
        }
        Num sumOfVolume = (Num)this.volumeIndicator.getValue(index);
        return sumOfMoneyFlowVolume.dividedBy(sumOfVolume);
    }

    private Num getMoneyFlowVolume(int index) {
        return ((Num)this.clvIndicator.getValue(index)).multipliedBy(this.getBarSeries().getBar(index).getVolume());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

