/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.statistics;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.SMAIndicator;
import org.ta4j.core.num.Num;

public class VarianceIndicator
extends CachedIndicator<Num> {
    private final Indicator<Num> indicator;
    private final int barCount;
    private final SMAIndicator sma;

    public VarianceIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.indicator = indicator;
        this.barCount = barCount;
        this.sma = new SMAIndicator(indicator, barCount);
    }

    @Override
    protected Num calculate(int index) {
        int startIndex = Math.max(0, index - this.barCount + 1);
        int numberOfObservations = index - startIndex + 1;
        Num variance = this.numOf(0);
        Num average = (Num)this.sma.getValue(index);
        for (int i = startIndex; i <= index; ++i) {
            Num pow = this.indicator.getValue(i).minus(average).pow(2);
            variance = variance.plus(pow);
        }
        variance = variance.dividedBy(this.numOf(numberOfObservations));
        return variance;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

