/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.statistics;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.statistics.StandardDeviationIndicator;
import org.ta4j.core.num.Num;

public class StandardErrorIndicator
extends CachedIndicator<Num> {
    private int barCount;
    private StandardDeviationIndicator sdev;

    public StandardErrorIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.barCount = barCount;
        this.sdev = new StandardDeviationIndicator(indicator, barCount);
    }

    @Override
    protected Num calculate(int index) {
        int startIndex = Math.max(0, index - this.barCount + 1);
        int numberOfObservations = index - startIndex + 1;
        return ((Num)this.sdev.getValue(index)).dividedBy(this.numOf(numberOfObservations).sqrt());
    }
}

