/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.statistics;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class SimpleLinearRegressionIndicator
extends CachedIndicator<Num> {
    private Indicator<Num> indicator;
    private int barCount;
    private Num slope;
    private Num intercept;
    private SimpleLinearRegressionType type;

    public SimpleLinearRegressionIndicator(Indicator<Num> indicator, int barCount) {
        this(indicator, barCount, SimpleLinearRegressionType.Y);
    }

    public SimpleLinearRegressionIndicator(Indicator<Num> indicator, int barCount, SimpleLinearRegressionType type) {
        super(indicator);
        this.indicator = indicator;
        this.barCount = barCount;
        this.type = type;
    }

    @Override
    protected Num calculate(int index) {
        int startIndex = Math.max(0, index - this.barCount + 1);
        if (index - startIndex + 1 < 2) {
            return NaN.NaN;
        }
        this.calculateRegressionLine(startIndex, index);
        if (this.type == SimpleLinearRegressionType.SLOPE) {
            return this.slope;
        }
        if (this.type == SimpleLinearRegressionType.INTERCEPT) {
            return this.intercept;
        }
        return this.slope.multipliedBy(this.numOf(index)).plus(this.intercept);
    }

    private void calculateRegressionLine(int startIndex, int endIndex) {
        Num sumX = this.numOf(0);
        Num sumY = this.numOf(0);
        for (int i = startIndex; i <= endIndex; ++i) {
            sumX = sumX.plus(this.numOf(i));
            sumY = sumY.plus(this.indicator.getValue(i));
        }
        Num nbObservations = this.numOf(endIndex - startIndex + 1);
        Num xBar = sumX.dividedBy(nbObservations);
        Num yBar = sumY.dividedBy(nbObservations);
        Num xxBar = this.numOf(0);
        Num xyBar = this.numOf(0);
        for (int i = startIndex; i <= endIndex; ++i) {
            Num dX = this.numOf(i).minus(xBar);
            Num dY = this.indicator.getValue(i).minus(yBar);
            xxBar = xxBar.plus(dX.multipliedBy(dX));
            xyBar = xyBar.plus(dX.multipliedBy(dY));
        }
        this.slope = xyBar.dividedBy(xxBar);
        this.intercept = yBar.minus(this.slope.multipliedBy(xBar));
    }

    public static enum SimpleLinearRegressionType {
        Y,
        SLOPE,
        INTERCEPT;

    }
}

