/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.statistics;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.SMAIndicator;
import org.ta4j.core.indicators.statistics.StandardDeviationIndicator;
import org.ta4j.core.num.Num;

public class SigmaIndicator
extends CachedIndicator<Num> {
    private static final long serialVersionUID = 6283425887025798038L;
    private Indicator<Num> ref;
    private int barCount;
    private SMAIndicator mean;
    private StandardDeviationIndicator sd;

    public SigmaIndicator(Indicator<Num> ref, int barCount) {
        super(ref);
        this.ref = ref;
        this.barCount = barCount;
        this.mean = new SMAIndicator(ref, barCount);
        this.sd = new StandardDeviationIndicator(ref, barCount);
    }

    @Override
    protected Num calculate(int index) {
        return this.ref.getValue(index).minus((Num)this.mean.getValue(index)).dividedBy((Num)this.sd.getValue(index));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

