/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.statistics;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class PeriodicalGrowthRateIndicator
extends CachedIndicator<Num> {
    private final Indicator<Num> indicator;
    private final int barCount;
    private final Num one;

    public PeriodicalGrowthRateIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.indicator = indicator;
        this.barCount = barCount;
        this.one = this.numOf(1);
    }

    public Num getTotalReturn() {
        Num totalProduct = this.one;
        int completeTimeFrames = this.getBarSeries().getBarCount() / this.barCount;
        for (int i = 1; i <= completeTimeFrames; ++i) {
            int index = i * this.barCount;
            Num currentReturn = (Num)this.getValue(index);
            if (currentReturn == NaN.NaN) continue;
            currentReturn = currentReturn.plus(this.one);
            totalProduct = totalProduct.multipliedBy(currentReturn);
        }
        return totalProduct.pow(this.one.dividedBy(this.numOf(completeTimeFrames)));
    }

    @Override
    protected Num calculate(int index) {
        Num currentValue = this.indicator.getValue(index);
        int helpPartialTimeframe = index % this.barCount;
        Num helpFullTimeframes = this.numOf(Math.floor(this.numOf(this.indicator.getBarSeries().getBarCount()).dividedBy(this.numOf(this.barCount)).doubleValue()));
        Num helpIndexTimeframes = this.numOf(index).dividedBy(this.numOf(this.barCount));
        Num helpPartialTimeframeHeld = this.numOf(helpPartialTimeframe).dividedBy(this.numOf(this.barCount));
        Num partialTimeframeHeld = helpPartialTimeframeHeld.isZero() ? this.one : helpPartialTimeframeHeld;
        Num timeframedReturn = NaN.NaN;
        if (index >= this.barCount && helpIndexTimeframes.isLessThan(helpFullTimeframes)) {
            Num movingValue = this.indicator.getValue(index - this.barCount);
            Num movingSimpleReturn = currentValue.minus(movingValue).dividedBy(movingValue);
            timeframedReturn = this.one.plus(movingSimpleReturn).pow(this.one.dividedBy(partialTimeframeHeld)).minus(this.one);
        }
        return timeframedReturn;
    }
}

