/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.statistics;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.RecursiveCachedIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class PearsonCorrelationIndicator
extends RecursiveCachedIndicator<Num> {
    private static final long serialVersionUID = 6317147143504055664L;
    private final Indicator<Num> indicator1;
    private final Indicator<Num> indicator2;
    private final int barCount;

    public PearsonCorrelationIndicator(Indicator<Num> indicator1, Indicator<Num> indicator2, int barCount) {
        super(indicator1);
        this.indicator1 = indicator1;
        this.indicator2 = indicator2;
        this.barCount = barCount;
    }

    @Override
    protected Num calculate(int index) {
        Num n = this.numOf(this.barCount);
        Num Sx = this.numOf(0);
        Num Sy = this.numOf(0);
        Num Sxx = this.numOf(0);
        Num Syy = this.numOf(0);
        Num Sxy = this.numOf(0);
        for (int i = Math.max(this.getBarSeries().getBeginIndex(), index - this.barCount + 1); i <= index; ++i) {
            Num x = this.indicator1.getValue(i);
            Num y = this.indicator2.getValue(i);
            Sx = Sx.plus(x);
            Sy = Sy.plus(y);
            Sxy = Sxy.plus(x.multipliedBy(y));
            Sxx = Sxx.plus(x.multipliedBy(x));
            Syy = Syy.plus(y.multipliedBy(y));
        }
        Num toSqrt = n.multipliedBy(Sxx).minus(Sx.multipliedBy(Sx)).multipliedBy(n.multipliedBy(Syy).minus(Sy.multipliedBy(Sy)));
        if (toSqrt.isGreaterThan(this.numOf(0))) {
            return n.multipliedBy(Sxy).minus(Sx.multipliedBy(Sy)).dividedBy(toSqrt.sqrt());
        }
        return NaN.NaN;
    }
}

