/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.statistics;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.SMAIndicator;
import org.ta4j.core.num.Num;

public class MeanDeviationIndicator
extends CachedIndicator<Num> {
    private final Indicator<Num> indicator;
    private final int barCount;
    private final SMAIndicator sma;

    public MeanDeviationIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.indicator = indicator;
        this.barCount = barCount;
        this.sma = new SMAIndicator(indicator, barCount);
    }

    @Override
    protected Num calculate(int index) {
        Num absoluteDeviations = this.numOf(0);
        Num average = (Num)this.sma.getValue(index);
        int startIndex = Math.max(0, index - this.barCount + 1);
        int nbValues = index - startIndex + 1;
        for (int i = startIndex; i <= index; ++i) {
            absoluteDeviations = absoluteDeviations.plus(this.indicator.getValue(i).minus(average).abs());
        }
        return absoluteDeviations.dividedBy(this.numOf(nbValues));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

