/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.statistics;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.SMAIndicator;
import org.ta4j.core.num.Num;

public class CovarianceIndicator
extends CachedIndicator<Num> {
    private final Indicator<Num> indicator1;
    private final Indicator<Num> indicator2;
    private final int barCount;
    private final SMAIndicator sma1;
    private final SMAIndicator sma2;

    public CovarianceIndicator(Indicator<Num> indicator1, Indicator<Num> indicator2, int barCount) {
        super(indicator1);
        this.indicator1 = indicator1;
        this.indicator2 = indicator2;
        this.barCount = barCount;
        this.sma1 = new SMAIndicator(indicator1, barCount);
        this.sma2 = new SMAIndicator(indicator2, barCount);
    }

    @Override
    protected Num calculate(int index) {
        int startIndex = Math.max(0, index - this.barCount + 1);
        int numberOfObservations = index - startIndex + 1;
        Num covariance = this.numOf(0);
        Num average1 = (Num)this.sma1.getValue(index);
        Num average2 = (Num)this.sma2.getValue(index);
        for (int i = startIndex; i <= index; ++i) {
            Num mul = this.indicator1.getValue(i).minus(average1).multipliedBy(this.indicator2.getValue(i).minus(average2));
            covariance = covariance.plus(mul);
        }
        covariance = covariance.dividedBy(this.numOf(numberOfObservations));
        return covariance;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

