/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.statistics;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.statistics.CovarianceIndicator;
import org.ta4j.core.indicators.statistics.VarianceIndicator;
import org.ta4j.core.num.Num;

public class CorrelationCoefficientIndicator
extends CachedIndicator<Num> {
    private final VarianceIndicator variance1;
    private final VarianceIndicator variance2;
    private final CovarianceIndicator covariance;

    public CorrelationCoefficientIndicator(Indicator<Num> indicator1, Indicator<Num> indicator2, int barCount) {
        super(indicator1);
        this.variance1 = new VarianceIndicator(indicator1, barCount);
        this.variance2 = new VarianceIndicator(indicator2, barCount);
        this.covariance = new CovarianceIndicator(indicator1, indicator2, barCount);
    }

    @Override
    protected Num calculate(int index) {
        Num cov = (Num)this.covariance.getValue(index);
        Num var1 = (Num)this.variance1.getValue(index);
        Num var2 = (Num)this.variance2.getValue(index);
        Num multipliedSqrt = var1.multipliedBy(var2).sqrt();
        return cov.dividedBy(multipliedSqrt);
    }
}

