/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.pivotpoints;

import java.util.List;
import org.ta4j.core.Bar;
import org.ta4j.core.indicators.RecursiveCachedIndicator;
import org.ta4j.core.indicators.pivotpoints.PivotLevel;
import org.ta4j.core.indicators.pivotpoints.PivotPointIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class StandardReversalIndicator
extends RecursiveCachedIndicator<Num> {
    private final PivotPointIndicator pivotPointIndicator;
    private final PivotLevel level;

    public StandardReversalIndicator(PivotPointIndicator pivotPointIndicator, PivotLevel level) {
        super(pivotPointIndicator);
        this.pivotPointIndicator = pivotPointIndicator;
        this.level = level;
    }

    @Override
    protected Num calculate(int index) {
        List<Integer> barsOfPreviousPeriod = this.pivotPointIndicator.getBarsOfPreviousPeriod(index);
        if (barsOfPreviousPeriod.isEmpty()) {
            return NaN.NaN;
        }
        switch (this.level) {
            case RESISTANCE_3: {
                return this.calculateR3(barsOfPreviousPeriod, index);
            }
            case RESISTANCE_2: {
                return this.calculateR2(barsOfPreviousPeriod, index);
            }
            case RESISTANCE_1: {
                return this.calculateR1(barsOfPreviousPeriod, index);
            }
            case SUPPORT_1: {
                return this.calculateS1(barsOfPreviousPeriod, index);
            }
            case SUPPORT_2: {
                return this.calculateS2(barsOfPreviousPeriod, index);
            }
            case SUPPORT_3: {
                return this.calculateS3(barsOfPreviousPeriod, index);
            }
        }
        return NaN.NaN;
    }

    private Num calculateR3(List<Integer> barsOfPreviousPeriod, int index) {
        Bar bar = this.getBarSeries().getBar(barsOfPreviousPeriod.get(0));
        Num low = bar.getLowPrice();
        Num high = bar.getHighPrice();
        for (int i : barsOfPreviousPeriod) {
            low = this.getBarSeries().getBar(i).getLowPrice().min(low);
            high = this.getBarSeries().getBar(i).getHighPrice().max(high);
        }
        return high.plus(this.numOf(2).multipliedBy(((Num)this.pivotPointIndicator.getValue(index)).minus(low)));
    }

    private Num calculateR2(List<Integer> barsOfPreviousPeriod, int index) {
        Bar bar = this.getBarSeries().getBar(barsOfPreviousPeriod.get(0));
        Num low = bar.getLowPrice();
        Num high = bar.getHighPrice();
        for (int i : barsOfPreviousPeriod) {
            low = this.getBarSeries().getBar(i).getLowPrice().min(low);
            high = this.getBarSeries().getBar(i).getHighPrice().max(high);
        }
        return ((Num)this.pivotPointIndicator.getValue(index)).plus(high.minus(low));
    }

    private Num calculateR1(List<Integer> barsOfPreviousPeriod, int index) {
        Num low = this.getBarSeries().getBar(barsOfPreviousPeriod.get(0)).getLowPrice();
        for (int i : barsOfPreviousPeriod) {
            low = this.getBarSeries().getBar(i).getLowPrice().min(low);
        }
        return this.numOf(2).multipliedBy((Num)this.pivotPointIndicator.getValue(index)).minus(low);
    }

    private Num calculateS1(List<Integer> barsOfPreviousPeriod, int index) {
        Num high = this.getBarSeries().getBar(barsOfPreviousPeriod.get(0)).getHighPrice();
        for (int i : barsOfPreviousPeriod) {
            high = this.getBarSeries().getBar(i).getHighPrice().max(high);
        }
        return this.numOf(2).multipliedBy((Num)this.pivotPointIndicator.getValue(index)).minus(high);
    }

    private Num calculateS2(List<Integer> barsOfPreviousPeriod, int index) {
        Bar bar = this.getBarSeries().getBar(barsOfPreviousPeriod.get(0));
        Num high = bar.getHighPrice();
        Num low = bar.getLowPrice();
        for (int i : barsOfPreviousPeriod) {
            high = this.getBarSeries().getBar(i).getHighPrice().max(high);
            low = this.getBarSeries().getBar(i).getLowPrice().min(low);
        }
        return ((Num)this.pivotPointIndicator.getValue(index)).minus(high.minus(low));
    }

    private Num calculateS3(List<Integer> barsOfPreviousPeriod, int index) {
        Bar bar = this.getBarSeries().getBar(barsOfPreviousPeriod.get(0));
        Num high = bar.getHighPrice();
        Num low = bar.getLowPrice();
        for (int i : barsOfPreviousPeriod) {
            high = this.getBarSeries().getBar(i).getHighPrice().max(high);
            low = this.getBarSeries().getBar(i).getLowPrice().min(low);
        }
        return low.minus(this.numOf(2).multipliedBy(high.minus((Num)this.pivotPointIndicator.getValue(index))));
    }
}

