/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.pivotpoints;

import java.time.temporal.IsoFields;
import java.util.ArrayList;
import java.util.List;
import org.ta4j.core.Bar;
import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.RecursiveCachedIndicator;
import org.ta4j.core.indicators.pivotpoints.TimeLevel;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class PivotPointIndicator
extends RecursiveCachedIndicator<Num> {
    private final TimeLevel timeLevel;

    public PivotPointIndicator(BarSeries series, TimeLevel timeLevel) {
        super(series);
        this.timeLevel = timeLevel;
    }

    @Override
    protected Num calculate(int index) {
        return this.calcPivotPoint(this.getBarsOfPreviousPeriod(index));
    }

    private Num calcPivotPoint(List<Integer> barsOfPreviousPeriod) {
        if (barsOfPreviousPeriod.isEmpty()) {
            return NaN.NaN;
        }
        Bar bar = this.getBarSeries().getBar(barsOfPreviousPeriod.get(0));
        Num close = bar.getClosePrice();
        Num high = bar.getHighPrice();
        Num low = bar.getLowPrice();
        for (int i : barsOfPreviousPeriod) {
            high = this.getBarSeries().getBar(i).getHighPrice().max(high);
            low = this.getBarSeries().getBar(i).getLowPrice().min(low);
        }
        return high.plus(low).plus(close).dividedBy(this.numOf(3));
    }

    public List<Integer> getBarsOfPreviousPeriod(int index) {
        ArrayList<Integer> previousBars = new ArrayList<Integer>();
        if (this.timeLevel == TimeLevel.BARBASED) {
            previousBars.add(Math.max(0, index - 1));
            return previousBars;
        }
        if (index == 0) {
            return previousBars;
        }
        Bar currentBar = this.getBarSeries().getBar(index);
        while (index - 1 > this.getBarSeries().getBeginIndex() && this.getPeriod(this.getBarSeries().getBar(index - 1)) == this.getPeriod(currentBar)) {
            --index;
        }
        long previousPeriod = this.getPreviousPeriod(currentBar, index - 1);
        while (index - 1 >= this.getBarSeries().getBeginIndex() && this.getPeriod(this.getBarSeries().getBar(index - 1)) == previousPeriod) {
            previousBars.add(--index);
        }
        return previousBars;
    }

    private long getPreviousPeriod(Bar bar, int indexOfPreviousBar) {
        switch (this.timeLevel) {
            case DAY: {
                int prevCalendarDay;
                for (prevCalendarDay = bar.getEndTime().minusDays(1L).getDayOfYear(); this.getBarSeries().getBar(indexOfPreviousBar).getEndTime().getDayOfYear() != prevCalendarDay && indexOfPreviousBar > 0 && prevCalendarDay >= 0; --prevCalendarDay) {
                }
                return prevCalendarDay;
            }
            case WEEK: {
                return bar.getEndTime().minusWeeks(1L).get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
            }
            case MONTH: {
                return bar.getEndTime().minusMonths(1L).getMonthValue();
            }
        }
        return bar.getEndTime().minusYears(1L).getYear();
    }

    private long getPeriod(Bar bar) {
        switch (this.timeLevel) {
            case DAY: {
                return bar.getEndTime().getDayOfYear();
            }
            case WEEK: {
                return bar.getEndTime().get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
            }
            case MONTH: {
                return bar.getEndTime().getMonthValue();
            }
        }
        return bar.getEndTime().getYear();
    }
}

