/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.pivotpoints;

import java.util.List;
import org.ta4j.core.Bar;
import org.ta4j.core.indicators.RecursiveCachedIndicator;
import org.ta4j.core.indicators.pivotpoints.PivotPointIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class FibonacciReversalIndicator
extends RecursiveCachedIndicator<Num> {
    private final PivotPointIndicator pivotPointIndicator;
    private final FibReversalTyp fibReversalTyp;
    private final Num fibonacciFactor;

    public FibonacciReversalIndicator(PivotPointIndicator pivotPointIndicator, double fibonacciFactor, FibReversalTyp fibReversalTyp) {
        super(pivotPointIndicator);
        this.pivotPointIndicator = pivotPointIndicator;
        this.fibonacciFactor = this.numOf(fibonacciFactor);
        this.fibReversalTyp = fibReversalTyp;
    }

    public FibonacciReversalIndicator(PivotPointIndicator pivotPointIndicator, FibonacciFactor fibonacciFactor, FibReversalTyp fibReversalTyp) {
        this(pivotPointIndicator, fibonacciFactor.getFactor(), fibReversalTyp);
    }

    @Override
    protected Num calculate(int index) {
        List<Integer> barsOfPreviousPeriod = this.pivotPointIndicator.getBarsOfPreviousPeriod(index);
        if (barsOfPreviousPeriod.isEmpty()) {
            return NaN.NaN;
        }
        Bar bar = this.getBarSeries().getBar(barsOfPreviousPeriod.get(0));
        Num high = bar.getHighPrice();
        Num low = bar.getLowPrice();
        for (int i : barsOfPreviousPeriod) {
            high = this.getBarSeries().getBar(i).getHighPrice().max(high);
            low = this.getBarSeries().getBar(i).getLowPrice().min(low);
        }
        if (this.fibReversalTyp == FibReversalTyp.RESISTANCE) {
            return ((Num)this.pivotPointIndicator.getValue(index)).plus(this.fibonacciFactor.multipliedBy(high.minus(low)));
        }
        return ((Num)this.pivotPointIndicator.getValue(index)).minus(this.fibonacciFactor.multipliedBy(high.minus(low)));
    }

    public static enum FibonacciFactor {
        FACTOR_1(0.382),
        FACTOR_2(0.618),
        FACTOR_3(1.0);

        private final double factor;

        private FibonacciFactor(double factor) {
            this.factor = factor;
        }

        public double getFactor() {
            return this.factor;
        }
    }

    public static enum FibReversalTyp {
        SUPPORT,
        RESISTANCE;

    }
}

