/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.pivotpoints;

import java.util.List;
import org.ta4j.core.Bar;
import org.ta4j.core.indicators.RecursiveCachedIndicator;
import org.ta4j.core.indicators.pivotpoints.DeMarkPivotPointIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class DeMarkReversalIndicator
extends RecursiveCachedIndicator<Num> {
    private final DeMarkPivotPointIndicator pivotPointIndicator;
    private final DeMarkPivotLevel level;
    private final Num two;

    public DeMarkReversalIndicator(DeMarkPivotPointIndicator pivotPointIndicator, DeMarkPivotLevel level) {
        super(pivotPointIndicator);
        this.pivotPointIndicator = pivotPointIndicator;
        this.level = level;
        this.two = this.numOf(2);
    }

    @Override
    protected Num calculate(int index) {
        Num x = ((Num)this.pivotPointIndicator.getValue(index)).multipliedBy(this.numOf(4));
        Num result = this.level == DeMarkPivotLevel.SUPPORT ? this.calculateSupport(x, index) : this.calculateResistance(x, index);
        return result;
    }

    private Num calculateResistance(Num x, int index) {
        List<Integer> barsOfPreviousPeriod = this.pivotPointIndicator.getBarsOfPreviousPeriod(index);
        if (barsOfPreviousPeriod.isEmpty()) {
            return NaN.NaN;
        }
        Bar bar = this.getBarSeries().getBar(barsOfPreviousPeriod.get(0));
        Num low = bar.getLowPrice();
        for (int i : barsOfPreviousPeriod) {
            low = this.getBarSeries().getBar(i).getLowPrice().min(low);
        }
        return x.dividedBy(this.two).minus(low);
    }

    private Num calculateSupport(Num x, int index) {
        List<Integer> barsOfPreviousPeriod = this.pivotPointIndicator.getBarsOfPreviousPeriod(index);
        if (barsOfPreviousPeriod.isEmpty()) {
            return NaN.NaN;
        }
        Bar bar = this.getBarSeries().getBar(barsOfPreviousPeriod.get(0));
        Num high = bar.getHighPrice();
        for (int i : barsOfPreviousPeriod) {
            high = this.getBarSeries().getBar(i).getHighPrice().max(high);
        }
        return x.dividedBy(this.two).minus(high);
    }

    public static enum DeMarkPivotLevel {
        RESISTANCE,
        SUPPORT;

    }
}

