/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.ichimoku;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.ClosePriceIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class IchimokuChikouSpanIndicator
extends CachedIndicator<Num> {
    private final ClosePriceIndicator closePriceIndicator;
    private final int timeDelay;

    public IchimokuChikouSpanIndicator(BarSeries series) {
        this(series, 26);
    }

    public IchimokuChikouSpanIndicator(BarSeries series, int timeDelay) {
        super(series);
        this.closePriceIndicator = new ClosePriceIndicator(series);
        this.timeDelay = timeDelay;
    }

    @Override
    protected Num calculate(int index) {
        int spanIndex = index + this.timeDelay;
        if (spanIndex <= this.getBarSeries().getEndIndex()) {
            return (Num)this.closePriceIndicator.getValue(spanIndex);
        }
        return NaN.NaN;
    }
}

