/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.ichimoku;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.helpers.HighPriceIndicator;
import org.ta4j.core.indicators.helpers.HighestValueIndicator;
import org.ta4j.core.indicators.helpers.LowPriceIndicator;
import org.ta4j.core.indicators.helpers.LowestValueIndicator;
import org.ta4j.core.num.Num;

public abstract class AbstractIchimokuLineIndicator
extends CachedIndicator<Num> {
    private final Indicator<Num> periodHigh;
    private final Indicator<Num> periodLow;

    public AbstractIchimokuLineIndicator(BarSeries series, int barCount) {
        super(series);
        this.periodHigh = new HighestValueIndicator(new HighPriceIndicator(series), barCount);
        this.periodLow = new LowestValueIndicator(new LowPriceIndicator(series), barCount);
    }

    @Override
    protected Num calculate(int index) {
        return this.periodHigh.getValue(index).plus(this.periodLow.getValue(index)).dividedBy(this.numOf(2));
    }
}

