/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.helpers;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.Num;

public class VolumeIndicator
extends CachedIndicator<Num> {
    private int barCount;

    public VolumeIndicator(BarSeries series) {
        this(series, 1);
    }

    public VolumeIndicator(BarSeries series, int barCount) {
        super(series);
        this.barCount = barCount;
    }

    @Override
    protected Num calculate(int index) {
        int startIndex = Math.max(0, index - this.barCount + 1);
        Num sumOfVolume = this.numOf(0);
        for (int i = startIndex; i <= index; ++i) {
            sumOfVolume = sumOfVolume.plus(this.getBarSeries().getBar(i).getVolume());
        }
        return sumOfVolume;
    }
}

