/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.helpers;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.Num;

public class HighestValueIndicator
extends CachedIndicator<Num> {
    private final Indicator<Num> indicator;
    private final int barCount;

    public HighestValueIndicator(Indicator<Num> indicator, int barCount) {
        super(indicator);
        this.indicator = indicator;
        this.barCount = barCount;
    }

    @Override
    protected Num calculate(int index) {
        if (this.indicator.getValue(index).isNaN() && this.barCount != 1) {
            return (Num)new HighestValueIndicator(this.indicator, this.barCount - 1).getValue(index - 1);
        }
        int end = Math.max(0, index - this.barCount + 1);
        Num highest = this.indicator.getValue(index);
        for (int i = index - 1; i >= end; --i) {
            if (!highest.isLessThan(this.indicator.getValue(i))) continue;
            highest = this.indicator.getValue(i);
        }
        return highest;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

