/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.helpers;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.NaN;
import org.ta4j.core.num.Num;

public class DifferencePercentage
extends CachedIndicator<Num> {
    private final Indicator<Num> indicator;
    private final Num percentageThreshold;
    private final Num hundred;
    private Num lastNotification;

    public DifferencePercentage(Indicator<Num> indicator) {
        this(indicator, indicator.numOf(0));
    }

    public DifferencePercentage(Indicator<Num> indicator, Number percentageThreshold) {
        this(indicator, indicator.numOf(percentageThreshold));
    }

    public DifferencePercentage(Indicator<Num> indicator, Num percentageThreshold) {
        super(indicator);
        this.indicator = indicator;
        this.percentageThreshold = percentageThreshold;
        this.hundred = this.numOf(100);
    }

    @Override
    protected Num calculate(int index) {
        Num value = this.indicator.getValue(index);
        if (this.lastNotification == null) {
            this.lastNotification = value;
            return NaN.NaN;
        }
        Num changeFraction = value.dividedBy(this.lastNotification);
        Num changePercentage = this.fractionToPercentage(changeFraction);
        if (changePercentage.abs().isGreaterThanOrEqual(this.percentageThreshold)) {
            this.lastNotification = value;
        }
        return changePercentage;
    }

    private Num fractionToPercentage(Num changeFraction) {
        return changeFraction.multipliedBy(this.hundred).minus(this.hundred);
    }
}

