/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.helpers;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.Num;

public class DecimalTransformIndicator
extends CachedIndicator<Num> {
    private static final long serialVersionUID = -8017034587193428498L;
    private Indicator<Num> indicator;
    private Num coefficient;
    private DecimalTransformType type;
    private DecimalTransformSimpleType simpleType;

    public DecimalTransformIndicator(Indicator<Num> indicator, double coefficient, DecimalTransformType type) {
        super(indicator);
        this.indicator = indicator;
        this.coefficient = this.numOf(coefficient);
        this.type = type;
    }

    public DecimalTransformIndicator(Indicator<Num> indicator, DecimalTransformSimpleType type) {
        super(indicator);
        this.indicator = indicator;
        this.simpleType = type;
    }

    @Override
    protected Num calculate(int index) {
        Num val = this.indicator.getValue(index);
        if (this.type != null) {
            switch (this.type) {
                case plus: {
                    return val.plus(this.coefficient);
                }
                case minus: {
                    return val.minus(this.coefficient);
                }
                case multiply: {
                    return val.multipliedBy(this.coefficient);
                }
                case divide: {
                    return val.dividedBy(this.coefficient);
                }
                case max: {
                    return val.max(this.coefficient);
                }
                case min: {
                    return val.min(this.coefficient);
                }
            }
        } else if (this.simpleType != null) {
            switch (this.simpleType) {
                case sqrt: {
                    return val.sqrt();
                }
                case abs: {
                    return val.abs();
                }
                case log: {
                    return this.numOf(Math.log(val.doubleValue()));
                }
            }
        }
        return val;
    }

    @Override
    public String toString() {
        if (this.type != null) {
            return this.getClass().getSimpleName() + " Coefficient: " + this.coefficient + " Transform(" + this.type.name() + ")";
        }
        return this.getClass().getSimpleName() + "Transform(" + this.simpleType.name() + ")";
    }

    public static enum DecimalTransformSimpleType {
        abs,
        sqrt,
        log;

    }

    public static enum DecimalTransformType {
        plus,
        minus,
        multiply,
        divide,
        max,
        min;

    }
}

