/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.helpers;

import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.adx.MinusDIIndicator;
import org.ta4j.core.indicators.adx.PlusDIIndicator;
import org.ta4j.core.num.Num;

public class DXIndicator
extends CachedIndicator<Num> {
    private final int barCount;
    private final PlusDIIndicator plusDIIndicator;
    private final MinusDIIndicator minusDIIndicator;

    public DXIndicator(BarSeries series, int barCount) {
        super(series);
        this.barCount = barCount;
        this.plusDIIndicator = new PlusDIIndicator(series, barCount);
        this.minusDIIndicator = new MinusDIIndicator(series, barCount);
    }

    @Override
    protected Num calculate(int index) {
        Num mdiValue;
        Num pdiValue = (Num)this.plusDIIndicator.getValue(index);
        if (pdiValue.plus(mdiValue = (Num)this.minusDIIndicator.getValue(index)).equals(this.numOf(0))) {
            return this.numOf(0);
        }
        return pdiValue.minus(mdiValue).abs().dividedBy(pdiValue.plus(mdiValue)).multipliedBy(this.numOf(100));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " barCount: " + this.barCount;
    }
}

