/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.helpers;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.Num;

public class CrossIndicator
extends CachedIndicator<Boolean> {
    private final Indicator<Num> up;
    private final Indicator<Num> low;

    public CrossIndicator(Indicator<Num> up, Indicator<Num> low) {
        super(up);
        this.up = up;
        this.low = low;
    }

    @Override
    protected Boolean calculate(int index) {
        int i = index;
        if (i == 0 || this.up.getValue(i).isGreaterThanOrEqual(this.low.getValue(i))) {
            return false;
        }
        if (this.up.getValue(--i).isGreaterThan(this.low.getValue(i))) {
            return true;
        }
        while (i > 0 && this.up.getValue(i).isEqual(this.low.getValue(i))) {
            --i;
        }
        return i != 0 && this.up.getValue(i).isGreaterThan(this.low.getValue(i));
    }

    public Indicator<Num> getLow() {
        return this.low;
    }

    public Indicator<Num> getUp() {
        return this.up;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.low + " " + this.up;
    }
}

