/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.helpers;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.statistics.CorrelationCoefficientIndicator;
import org.ta4j.core.indicators.statistics.SimpleLinearRegressionIndicator;
import org.ta4j.core.num.Num;
import org.ta4j.core.trading.rules.IsFallingRule;
import org.ta4j.core.trading.rules.IsRisingRule;

public class ConvergenceDivergenceIndicator
extends CachedIndicator<Boolean> {
    private static final long serialVersionUID = -6735646430246479066L;
    private final Indicator<Num> ref;
    private final Indicator<Num> other;
    private final int barCount;
    private final ConvergenceDivergenceType type;
    private final ConvergenceDivergenceStrictType strictType;
    private Num minStrength;
    private final Num minSlope;

    public ConvergenceDivergenceIndicator(Indicator<Num> ref, Indicator<Num> other, int barCount, ConvergenceDivergenceType type, double minStrength, double minSlope) {
        super(ref);
        this.ref = ref;
        this.other = other;
        this.barCount = barCount;
        this.type = type;
        this.strictType = null;
        this.minStrength = this.numOf(minStrength).abs();
        this.minSlope = this.numOf(minSlope);
    }

    public ConvergenceDivergenceIndicator(Indicator<Num> ref, Indicator<Num> other, int barCount, ConvergenceDivergenceType type) {
        super(ref);
        this.ref = ref;
        this.other = other;
        this.barCount = barCount;
        this.type = type;
        this.strictType = null;
        this.minStrength = this.numOf(0.8).abs();
        this.minSlope = this.numOf(0.3);
    }

    public ConvergenceDivergenceIndicator(Indicator<Num> ref, Indicator<Num> other, int barCount, ConvergenceDivergenceStrictType strictType) {
        super(ref);
        this.ref = ref;
        this.other = other;
        this.barCount = barCount;
        this.type = null;
        this.strictType = strictType;
        this.minStrength = null;
        this.minSlope = null;
    }

    @Override
    protected Boolean calculate(int index) {
        if (this.minStrength != null && this.minStrength.isZero()) {
            return false;
        }
        if (this.minStrength != null && this.minStrength.isGreaterThan(this.numOf(1))) {
            this.minStrength = this.numOf(1);
        }
        if (this.type != null) {
            switch (this.type) {
                case positiveConvergent: {
                    return this.calculatePositiveConvergence(index);
                }
                case negativeConvergent: {
                    return this.calculateNegativeConvergence(index);
                }
                case positiveDivergent: {
                    return this.calculatePositiveDivergence(index);
                }
                case negativeDivergent: {
                    return this.calculateNegativeDivergence(index);
                }
            }
            return false;
        }
        if (this.strictType != null) {
            switch (this.strictType) {
                case positiveConvergentStrict: {
                    return this.calculatePositiveConvergenceStrict(index);
                }
                case negativeConvergentStrict: {
                    return this.calculateNegativeConvergenceStrict(index);
                }
                case positiveDivergentStrict: {
                    return this.calculatePositiveDivergenceStrict(index);
                }
                case negativeDivergentStrict: {
                    return this.calculateNegativeDivergenceStrict(index);
                }
            }
            return false;
        }
        return false;
    }

    private Boolean calculatePositiveConvergenceStrict(int index) {
        IsRisingRule refIsRising = new IsRisingRule(this.ref, this.barCount);
        IsRisingRule otherIsRising = new IsRisingRule(this.ref, this.barCount);
        return refIsRising.and(otherIsRising).isSatisfied(index);
    }

    private Boolean calculateNegativeConvergenceStrict(int index) {
        IsFallingRule refIsFalling = new IsFallingRule(this.ref, this.barCount);
        IsFallingRule otherIsFalling = new IsFallingRule(this.ref, this.barCount);
        return refIsFalling.and(otherIsFalling).isSatisfied(index);
    }

    private Boolean calculatePositiveDivergenceStrict(int index) {
        IsRisingRule refIsRising = new IsRisingRule(this.ref, this.barCount);
        IsFallingRule otherIsFalling = new IsFallingRule(this.ref, this.barCount);
        return refIsRising.and(otherIsFalling).isSatisfied(index);
    }

    private Boolean calculateNegativeDivergenceStrict(int index) {
        IsFallingRule refIsFalling = new IsFallingRule(this.ref, this.barCount);
        IsRisingRule otherIsRising = new IsRisingRule(this.ref, this.barCount);
        return refIsFalling.and(otherIsRising).isSatisfied(index);
    }

    private Boolean calculatePositiveConvergence(int index) {
        CorrelationCoefficientIndicator cc = new CorrelationCoefficientIndicator(this.ref, this.other, this.barCount);
        boolean isConvergent = ((Num)cc.getValue(index)).isGreaterThanOrEqual(this.minStrength);
        Num slope = this.calculateSlopeRel(index);
        boolean isPositive = slope.isGreaterThanOrEqual(this.minSlope.abs());
        return isConvergent && isPositive;
    }

    private Boolean calculateNegativeConvergence(int index) {
        CorrelationCoefficientIndicator cc = new CorrelationCoefficientIndicator(this.ref, this.other, this.barCount);
        boolean isConvergent = ((Num)cc.getValue(index)).isGreaterThanOrEqual(this.minStrength);
        Num slope = this.calculateSlopeRel(index);
        boolean isNegative = slope.isLessThanOrEqual(this.minSlope.abs().multipliedBy(this.numOf(-1)));
        return isConvergent && isNegative;
    }

    private Boolean calculatePositiveDivergence(int index) {
        CorrelationCoefficientIndicator cc = new CorrelationCoefficientIndicator(this.ref, this.other, this.barCount);
        boolean isDivergent = ((Num)cc.getValue(index)).isLessThanOrEqual(this.minStrength.multipliedBy(this.numOf(-1)));
        if (isDivergent) {
            Num slope = this.calculateSlopeRel(index);
            return slope.isGreaterThanOrEqual(this.minSlope.abs());
        }
        return false;
    }

    private Boolean calculateNegativeDivergence(int index) {
        CorrelationCoefficientIndicator cc = new CorrelationCoefficientIndicator(this.ref, this.other, this.barCount);
        boolean isDivergent = ((Num)cc.getValue(index)).isLessThanOrEqual(this.minStrength.multipliedBy(this.numOf(-1)));
        if (isDivergent) {
            Num slope = this.calculateSlopeRel(index);
            return slope.isLessThanOrEqual(this.minSlope.abs().multipliedBy(this.numOf(-1)));
        }
        return false;
    }

    private Num calculateSlopeRel(int index) {
        SimpleLinearRegressionIndicator slrRef = new SimpleLinearRegressionIndicator(this.ref, this.barCount);
        int firstIndex = Math.max(0, index - this.barCount + 1);
        return ((Num)slrRef.getValue(index)).minus((Num)slrRef.getValue(firstIndex)).dividedBy((Num)slrRef.getValue(index));
    }

    public static enum ConvergenceDivergenceStrictType {
        positiveConvergentStrict,
        negativeConvergentStrict,
        positiveDivergentStrict,
        negativeDivergentStrict;

    }

    public static enum ConvergenceDivergenceType {
        positiveConvergent,
        negativeConvergent,
        positiveDivergent,
        negativeDivergent;

    }
}

