/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.helpers;

import org.ta4j.core.Bar;
import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.Num;

public class CloseLocationValueIndicator
extends CachedIndicator<Num> {
    private final Num zero = this.numOf(0);

    public CloseLocationValueIndicator(BarSeries series) {
        super(series);
    }

    @Override
    protected Num calculate(int index) {
        Bar bar = this.getBarSeries().getBar(index);
        Num low = bar.getLowPrice();
        Num high = bar.getHighPrice();
        Num close = bar.getClosePrice();
        Num diffHighLow = high.minus(low);
        return diffHighLow.isNaN() ? this.zero : close.minus(low).minus(high.minus(close)).dividedBy(diffHighLow);
    }
}

