/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.helpers;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.Num;

public class BooleanTransformIndicator
extends CachedIndicator<Boolean> {
    private static final long serialVersionUID = -6196778603319962795L;
    private Indicator<Num> indicator;
    private Num coefficient;
    private BooleanTransformType type;
    private BooleanTransformSimpleType simpleType;

    public BooleanTransformIndicator(Indicator<Num> indicator, Num coefficient, BooleanTransformType type) {
        super(indicator);
        this.indicator = indicator;
        this.coefficient = coefficient;
        this.type = type;
    }

    public BooleanTransformIndicator(Indicator<Num> indicator, BooleanTransformSimpleType type) {
        super(indicator);
        this.indicator = indicator;
        this.simpleType = type;
    }

    @Override
    protected Boolean calculate(int index) {
        Num val = this.indicator.getValue(index);
        if (this.type != null) {
            switch (this.type) {
                case equals: {
                    return val.equals(this.coefficient);
                }
                case isGreaterThan: {
                    return val.isGreaterThan(this.coefficient);
                }
                case isGreaterThanOrEqual: {
                    return val.isGreaterThanOrEqual(this.coefficient);
                }
                case isLessThan: {
                    return val.isLessThan(this.coefficient);
                }
                case isLessThanOrEqual: {
                    return val.isLessThanOrEqual(this.coefficient);
                }
            }
        } else if (this.simpleType != null) {
            switch (this.simpleType) {
                case isNaN: {
                    return val.isNaN();
                }
                case isNegative: {
                    return val.isNegative();
                }
                case isNegativeOrZero: {
                    return val.isNegativeOrZero();
                }
                case isPositive: {
                    return val.isPositive();
                }
                case isPositiveOrZero: {
                    return val.isPositiveOrZero();
                }
                case isZero: {
                    return val.isZero();
                }
            }
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.type != null) {
            return this.getClass().getSimpleName() + " Coefficient: " + this.coefficient + " Transform(" + this.type.name() + ")";
        }
        return this.getClass().getSimpleName() + "Transform(" + this.simpleType.name() + ")";
    }

    public static enum BooleanTransformSimpleType {
        isNaN,
        isNegative,
        isNegativeOrZero,
        isPositive,
        isPositiveOrZero,
        isZero;

    }

    public static enum BooleanTransformType {
        equals,
        isGreaterThan,
        isGreaterThanOrEqual,
        isLessThan,
        isLessThanOrEqual;

    }
}

