/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.candles;

import org.ta4j.core.Bar;
import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.SMAIndicator;
import org.ta4j.core.indicators.candles.UpperShadowIndicator;
import org.ta4j.core.num.Num;

public class ThreeWhiteSoldiersIndicator
extends CachedIndicator<Boolean> {
    private final UpperShadowIndicator upperShadowInd;
    private final SMAIndicator averageUpperShadowInd;
    private final Num factor;
    private int blackCandleIndex = -1;

    public ThreeWhiteSoldiersIndicator(BarSeries series, int barCount, Num factor) {
        super(series);
        this.upperShadowInd = new UpperShadowIndicator(series);
        this.averageUpperShadowInd = new SMAIndicator(this.upperShadowInd, barCount);
        this.factor = factor;
    }

    @Override
    protected Boolean calculate(int index) {
        if (index < 3) {
            return false;
        }
        this.blackCandleIndex = index - 3;
        return this.getBarSeries().getBar(this.blackCandleIndex).isBearish() && this.isWhiteSoldier(index - 2) && this.isWhiteSoldier(index - 1) && this.isWhiteSoldier(index);
    }

    private boolean hasVeryShortUpperShadow(int index) {
        Num currentUpperShadow = (Num)this.upperShadowInd.getValue(index);
        Num averageUpperShadow = (Num)this.averageUpperShadowInd.getValue(this.blackCandleIndex);
        return currentUpperShadow.isLessThan(averageUpperShadow.multipliedBy(this.factor));
    }

    private boolean isGrowing(int index) {
        Bar prevBar = this.getBarSeries().getBar(index - 1);
        Bar currBar = this.getBarSeries().getBar(index);
        Num prevOpenPrice = prevBar.getOpenPrice();
        Num prevClosePrice = prevBar.getClosePrice();
        Num currOpenPrice = currBar.getOpenPrice();
        Num currClosePrice = currBar.getClosePrice();
        return currOpenPrice.isGreaterThan(prevOpenPrice) && currOpenPrice.isLessThan(prevClosePrice) && currClosePrice.isGreaterThan(prevClosePrice);
    }

    private boolean isWhiteSoldier(int index) {
        Bar prevBar = this.getBarSeries().getBar(index - 1);
        Bar currBar = this.getBarSeries().getBar(index);
        if (currBar.isBullish()) {
            if (prevBar.isBearish()) {
                return this.hasVeryShortUpperShadow(index) && currBar.getOpenPrice().isGreaterThan(prevBar.getLowPrice());
            }
            return this.hasVeryShortUpperShadow(index) && this.isGrowing(index);
        }
        return false;
    }
}

