/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.candles;

import org.ta4j.core.Bar;
import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.SMAIndicator;
import org.ta4j.core.indicators.candles.LowerShadowIndicator;
import org.ta4j.core.num.Num;

public class ThreeBlackCrowsIndicator
extends CachedIndicator<Boolean> {
    private final LowerShadowIndicator lowerShadowInd;
    private final SMAIndicator averageLowerShadowInd;
    private final Num factor;
    private int whiteCandleIndex = -1;

    public ThreeBlackCrowsIndicator(BarSeries series, int barCount, double factor) {
        super(series);
        this.lowerShadowInd = new LowerShadowIndicator(series);
        this.averageLowerShadowInd = new SMAIndicator(this.lowerShadowInd, barCount);
        this.factor = this.numOf(factor);
    }

    @Override
    protected Boolean calculate(int index) {
        if (index < 3) {
            return false;
        }
        this.whiteCandleIndex = index - 3;
        return this.getBarSeries().getBar(this.whiteCandleIndex).isBullish() && this.isBlackCrow(index - 2) && this.isBlackCrow(index - 1) && this.isBlackCrow(index);
    }

    private boolean hasVeryShortLowerShadow(int index) {
        Num currentLowerShadow = (Num)this.lowerShadowInd.getValue(index);
        Num averageLowerShadow = (Num)this.averageLowerShadowInd.getValue(this.whiteCandleIndex);
        return currentLowerShadow.isLessThan(averageLowerShadow.multipliedBy(this.factor));
    }

    private boolean isDeclining(int index) {
        Bar prevBar = this.getBarSeries().getBar(index - 1);
        Bar currBar = this.getBarSeries().getBar(index);
        Num prevOpenPrice = prevBar.getOpenPrice();
        Num prevClosePrice = prevBar.getClosePrice();
        Num currOpenPrice = currBar.getOpenPrice();
        Num currClosePrice = currBar.getClosePrice();
        return currOpenPrice.isLessThan(prevOpenPrice) && currOpenPrice.isGreaterThan(prevClosePrice) && currClosePrice.isLessThan(prevClosePrice);
    }

    private boolean isBlackCrow(int index) {
        Bar prevBar = this.getBarSeries().getBar(index - 1);
        Bar currBar = this.getBarSeries().getBar(index);
        if (currBar.isBearish()) {
            if (prevBar.isBullish()) {
                return this.hasVeryShortLowerShadow(index) && currBar.getOpenPrice().isLessThan(prevBar.getHighPrice());
            }
            return this.hasVeryShortLowerShadow(index) && this.isDeclining(index);
        }
        return false;
    }
}

