/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.candles;

import org.ta4j.core.BarSeries;
import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.SMAIndicator;
import org.ta4j.core.indicators.candles.RealBodyIndicator;
import org.ta4j.core.indicators.helpers.AbsoluteIndicator;
import org.ta4j.core.num.Num;

public class DojiIndicator
extends CachedIndicator<Boolean> {
    private final Indicator<Num> bodyHeightInd;
    private final SMAIndicator averageBodyHeightInd;
    private final Num factor;

    public DojiIndicator(BarSeries series, int barCount, double bodyFactor) {
        super(series);
        this.bodyHeightInd = new AbsoluteIndicator(new RealBodyIndicator(series));
        this.averageBodyHeightInd = new SMAIndicator(this.bodyHeightInd, barCount);
        this.factor = this.numOf(bodyFactor);
    }

    @Override
    protected Boolean calculate(int index) {
        if (index < 1) {
            return this.bodyHeightInd.getValue(index).isZero();
        }
        Num averageBodyHeight = (Num)this.averageBodyHeightInd.getValue(index - 1);
        Num currentBodyHeight = this.bodyHeightInd.getValue(index);
        return currentBodyHeight.isLessThan(averageBodyHeight.multipliedBy(this.factor));
    }
}

