/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.candles;

import org.ta4j.core.Bar;
import org.ta4j.core.BarSeries;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.num.Num;

public class BullishHaramiIndicator
extends CachedIndicator<Boolean> {
    public BullishHaramiIndicator(BarSeries series) {
        super(series);
    }

    @Override
    protected Boolean calculate(int index) {
        if (index < 1) {
            return false;
        }
        Bar prevBar = this.getBarSeries().getBar(index - 1);
        Bar currBar = this.getBarSeries().getBar(index);
        if (prevBar.isBearish() && currBar.isBullish()) {
            Num prevOpenPrice = prevBar.getOpenPrice();
            Num prevClosePrice = prevBar.getClosePrice();
            Num currOpenPrice = currBar.getOpenPrice();
            Num currClosePrice = currBar.getClosePrice();
            return currOpenPrice.isLessThan(prevOpenPrice) && currOpenPrice.isGreaterThan(prevClosePrice) && currClosePrice.isLessThan(prevOpenPrice) && currClosePrice.isGreaterThan(prevClosePrice);
        }
        return false;
    }
}

