/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.bollinger;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.SMAIndicator;
import org.ta4j.core.indicators.bollinger.BollingerBandsLowerIndicator;
import org.ta4j.core.indicators.bollinger.BollingerBandsMiddleIndicator;
import org.ta4j.core.indicators.bollinger.BollingerBandsUpperIndicator;
import org.ta4j.core.indicators.statistics.StandardDeviationIndicator;
import org.ta4j.core.num.Num;

public class PercentBIndicator
extends CachedIndicator<Num> {
    private final Indicator<Num> indicator;
    private final BollingerBandsUpperIndicator bbu;
    private final BollingerBandsLowerIndicator bbl;

    public PercentBIndicator(Indicator<Num> indicator, int barCount, double k) {
        super(indicator);
        this.indicator = indicator;
        BollingerBandsMiddleIndicator bbm = new BollingerBandsMiddleIndicator(new SMAIndicator(indicator, barCount));
        StandardDeviationIndicator sd = new StandardDeviationIndicator(indicator, barCount);
        this.bbu = new BollingerBandsUpperIndicator(bbm, sd, this.numOf(k));
        this.bbl = new BollingerBandsLowerIndicator(bbm, sd, this.numOf(k));
    }

    @Override
    protected Num calculate(int index) {
        Num value = this.indicator.getValue(index);
        Num upValue = (Num)this.bbu.getValue(index);
        Num lowValue = (Num)this.bbl.getValue(index);
        return value.minus(lowValue).dividedBy(upValue.minus(lowValue));
    }
}

