/*
 * Decompiled with CFR 0.152.
 */
package org.ta4j.core.indicators.bollinger;

import org.ta4j.core.Indicator;
import org.ta4j.core.indicators.CachedIndicator;
import org.ta4j.core.indicators.bollinger.BollingerBandsMiddleIndicator;
import org.ta4j.core.num.Num;

public class BollingerBandsUpperIndicator
extends CachedIndicator<Num> {
    private final Indicator<Num> deviation;
    private final BollingerBandsMiddleIndicator bbm;
    private final Num k;

    public BollingerBandsUpperIndicator(BollingerBandsMiddleIndicator bbm, Indicator<Num> deviation) {
        this(bbm, deviation, bbm.getBarSeries().numOf(2));
    }

    public BollingerBandsUpperIndicator(BollingerBandsMiddleIndicator bbm, Indicator<Num> deviation, Num k) {
        super(deviation);
        this.bbm = bbm;
        this.deviation = deviation;
        this.k = k;
    }

    @Override
    protected Num calculate(int index) {
        return ((Num)this.bbm.getValue(index)).plus(this.deviation.getValue(index).multipliedBy(this.k));
    }

    public Num getK() {
        return this.k;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "k: " + this.k + "deviation: " + this.deviation + "series" + this.bbm;
    }
}

